﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="System.Diagnostics" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie list płac</title>
		<script runat="server">

	//Max długość opisu z numerami list płac. 
	// 0: bez limitu.
	//-1: nie drukuj listy numerów na podsumowaniu
	static int maxOpisLen = 0;
	
    class Total: IComparable {
           readonly DefinicjaElementu definicja;
           readonly string nazwa;
           readonly bool potrącenie;
           readonly bool zasiłek;
           int liczbaOP;
           decimal wartośćOP;
           int liczbaNp;
           decimal wartośćNp;
           public Total(WypElement element, string nazwa) {
               definicja = element.Definicja;
               potrącenie = definicja.Info.Potrącenie;
               zasiłek = definicja.Info.ZasiłekBudżet || element.ZasiłekZus;
               this.nazwa = nazwa;
           }
           public void Add(WypElement element) {
               decimal op = element.DoOpodatkowania;
               if (op != 0) {
                   wartośćOP += op;
                   liczbaOP++;
               }

               decimal np = element.NiePodlegaOpodatkowaniu;
               if (np != 0) {
                   wartośćNp += np;
                   liczbaNp++;
               }
           }
           public int CompareTo(object v) {
               return string.Compare(Nazwa, ((Total)v).Nazwa, true);
           }
           public bool Opodatkowany {
               get { return definicja.Info.Opodatkowany; }
           }
           public bool PodstZUS {
               get { return definicja.Info.PodstawaZUS; }
           }
           public bool PodstZdrow {
               get { return definicja.Info.PodstawaZdrow; }
           }
           public bool Zasiłek {
               get { return zasiłek; }
           }
           public string Nazwa {
               get { return nazwa; }
           }
           public int LiczbaOP {
               get { return liczbaOP; }
           }
           public decimal DodatkiOP {
               get { return potrącenie ? 0m : wartośćOP; }
           }
           public decimal PotrąceniaOP {
               get { return potrącenie ? -wartośćOP : 0m; }
           }
           public int LiczbaNp {
               get { return liczbaNp; }
           }
           public decimal DodatkiNp {
               get { return potrącenie ? 0m : wartośćNp; }
           }
           public decimal PotrąceniaNp {
               get { return potrącenie ? -wartośćNp : 0m; }
           }
       }
    
       class Składka {
           string nazwa;
           decimal podstawa;
           decimal prac;
           decimal firma;
           public Składka(string nazwa) {
               this.nazwa = nazwa;
           }
           public void Add(ISkładka składka) {
               podstawa += składka.Podstawa;
               prac += składka.Prac;
               firma += składka.Firma;
           }
           public void Add(decimal podstawa, decimal prac, decimal firma) {
               this.podstawa += podstawa;
               this.prac += prac;
               this.firma += firma;
           }

           public string Nazwa {
               get { return nazwa; }
           }
           public decimal Podstawa {
               get { return podstawa; }
           }
           public decimal Prac {
               get { return prac; }
           }
           public decimal Firma {
               get { return firma; }
           }
           public decimal Razem {
               get { return prac + firma; }
           }
       }
    
       class Kwota {
           string nazwa;
           decimal wartość;
           public Kwota(string nazwa) {
               this.nazwa = nazwa;
           }
           public void Add(decimal wartość) {
               this.wartość += wartość;
           }
           public string Nazwa {
               get { return nazwa; }
           }
           public decimal Wartość {
               get { return wartość; }
           }
       }
    
       class Wypłata {
           Currency gotówka;
           Currency przelew;
           public void Add(Wyplata wypłata) {
               foreach (Soneta.Kasa.Platnosc p in wypłata.Platnosci) {
                   Currency kwota = p.Kwota;
                   if (p.SposobZaplaty.Typ == Soneta.Kasa.TypySposobowZaplaty.Gotówka)
                       gotówka = gotówka.AddExt(Wartość(p, kwota));
                   else
                       przelew = przelew.AddExt(kwota);
               }
           }
           public decimal Razem {
               get { return gotówka.Value + przelew.Value; }
           }
           public decimal Gotówka {
               get { return gotówka.Value; }
           }
           public decimal Przelew {
               get { return przelew.Value; }
           }
           private Currency Wartość(Soneta.Kasa.Platnosc płatność, Currency kwota) {
               return płatność is Soneta.Kasa.Zobowiazanie ? kwota : -kwota;
           }
       }
    
       class LiczbaElementow {
			readonly string opis;
			readonly int liczba;
			public LiczbaElementow(string opis, int liczba) {
				this.opis = opis;
				this.liczba = liczba;
			}
			public string Opis {
				get { return opis; }
			}
				
			public int Liczba {
				get { return liczba; }
			}
       }
       
       class Podsumowanie: IComparable {

            readonly SrParams srpars;
           
			int IComparable.CompareTo(object v) {
				if (v==null)
					return 1;
				Podsumowanie p = v as Podsumowanie;
				if (p==null)
					throw new ArgumentException("v");
				return pracownik.CompareTo(p.pracownik);
			}
			
		   int cwyplaty = 0;
		   int celementy = 0;
           Pracownik pracownik;
           Hashtable ht = new Hashtable();
           Składka[] składkiZUS = new Składka[4];
           List<Składka> składkiNFZ = new List<Składka>();
           Składka[] składkiPoz = new Składka[3];
           Składka[] składkiPPK = new Składka[2];
           List<Kwota> podatki = new List<Kwota>();
           Wypłata[] wypłaty = new Wypłata[1];
           ArrayList opodatkowaneZUS;
           ArrayList opodatkowaneZdrow;
           ArrayList opodatkowane;
           ArrayList zasiłki;
           ArrayList nieOpodatkowane;
           ArrayList nieOpZasiłki;
           string numeryWypłat = "";
           ListaPlac lista;
           FromTo okres;
           bool isPolskiLad;
    
           public Podsumowanie(ListaPlac lista, Pracownik pracownik, FromTo okres, SrParams srpars, bool IsPolskiLad) {
               this.srpars = srpars;
               this.pracownik = pracownik;
               this.lista = lista;
               this.okres = okres;
               this.isPolskiLad = IsPolskiLad;
    
               składkiZUS[0] = new Składka("Ubezpieczenie emerytalne");
               składkiZUS[1] = new Składka("Ubezpieczenie rentowe");
               składkiZUS[2] = new Składka("Ubezpieczenie chorobowe");
               składkiZUS[3] = new Składka("Ubezpieczenie wypadkowe");
    
               składkiNFZ.Add(new Składka("Składka".Translate()));
                if (!IsPolskiLad)
                {
                    składkiNFZ.Add(new Składka("Do odliczenia od podstawy opodatkowania".Translate()));
                    składkiNFZ.Add(new Składka("Nieodliczana od podstawy opodatkowania".Translate()));
                }
    
               składkiPoz[0] = new Składka("Fundusz Pracy");
               składkiPoz[1] = new Składka("Fundusz Gwarant.Świadczeń Pracow.");
               składkiPoz[2] = new Składka("Fundusz Emerytur Pomostowych");

               składkiPPK[0] = new Składka("Pracownika".Translate());
               składkiPPK[1] = new Składka("Pracodawcy".Translate());

                podatki.Add(new Kwota("Przychód".Translate()));
                podatki.Add(new Kwota("Suma składek ZUS".Translate()));
                podatki.Add(new Kwota("Koszty uzyskania".Translate()));
                podatki.Add(new Kwota("Ulga podatkowa".Translate()));
               if (IsPolskiLad)
                    podatki.Add(new Kwota("Ulga klasa średnia".Translate()));

                podatki.Add(new Kwota("Podatek naliczony (wynagrodzenia)".Translate()));
                podatki.Add(new Kwota("Podatek naliczony (zasiłki)".Translate()));
               if (!IsPolskiLad)
                    podatki.Add(new Kwota("Zdrowotne do odliczenia".Translate()));

                podatki.Add(new Kwota("Zaniechanie poboru zaliczki".Translate()));
                podatki.Add(new Kwota("Zaliczka podatku do odprowadzenia do urzędu skarbowego".Translate()));
    
               wypłaty[0] = new Wypłata();
           }
    
           public void Add(IEnumerable lista) {
               foreach (Wyplata wyplata in lista) {
					string ss = wyplata.Numer.Pelny;
					if (numeryWypłat=="")
						numeryWypłat = ss;
					else
						numeryWypłat += ", " + ss;
                   cwyplaty++;
                   wypłaty[0].Add(wyplata);
                   foreach (WypElement element in wyplata.Elementy) {
                       celementy++;
					   object key;
					   string nazwa;
					   if (srpars.AkordWgDef && element is WypElementAkord) {
							WypElementAkord wea = (WypElementAkord)element;
							nazwa = element.Definicja.Nazwa + "/" + wea.Akord.Definicja.Nazwa;
							key = wea.Akord.Definicja;
					   }
					   else {
							nazwa = element.Definicja.Nazwa;
							key = element.Definicja;
					   }
					   
                       Total tot = (Total)ht[key];
                       if (tot==null) {
                           tot = new Total(element, nazwa);
                           ht[key] = tot;
                       }
                       tot.Add(element);
                       Podatki p = element.Podatki;
                       składkiZUS[0].Add(p.Emerytalna);
                       składkiZUS[1].Add(p.Rentowa);
                       składkiZUS[2].Add(p.Chorobowa);
                       składkiZUS[3].Add(p.Wypadkowa);
                      składkiNFZ[0].Add(p.Zdrowotna.Podstawa, p.Zdrowotna.Prac, p.Zdrowotna.Firma);
                         if (!this.isPolskiLad)
                        {
                            składkiNFZ[1].Add(0m, p.ZdrowotneDoOdliczenia, 0m);
                            składkiNFZ[2].Add(0m, p.ZdrowotneNieodliczane, 0m);
                        }
                       składkiPoz[0].Add(p.FP);
                       składkiPoz[1].Add(p.FGSP);
                       składkiPoz[2].Add(p.FEP);

                        składkiPPK[0].Add(p.PPK.Podstawa, p.PPK.PodstPracownika, p.PPK.DodPracownika);
                        składkiPPK[1].Add(p.PPK.Podstawa, p.PPK.PodstPracodawcy, p.PPK.DodPracodawcy);
    
                       //if (element.Definicja.Info.Opodatkowany)
                       //    podatki[0].Add(element.Wartosc);
                       podatki[0].Add(element.DoOpodatkowania);        //TID: 9695
                       podatki[1].Add(p.KosztyZUS);
                       podatki[2].Add(p.Koszty + p.Koszty50);
                       podatki[3].Add(p.Ulga);

                          if (this.isPolskiLad)
                        {
                            podatki[4].Add(p.UlgaKlasaSrednia);

                            KodRSA rsa = element.KodRSA;
                            if (!(rsa != null && (rsa.Chorobowe || rsa.Wypadkowe)))
                                podatki[5].Add(p.NalFIS);
                            else
                                podatki[6].Add(p.NalFIS);

                                podatki[7].Add(p.Zaniechanie);
                                podatki[8].Add(p.ZalFIS);
                        }
                        else
                        {
                            KodRSA rsa = element.KodRSA;
                            if (!(rsa != null && (rsa.Chorobowe || rsa.Wypadkowe)))
                                podatki[4].Add(p.NalFIS);
                            else
                                podatki[5].Add(p.NalFIS);

                                podatki[6].Add(p.ZdrowotneDoOdliczenia);
                                podatki[7].Add(p.Zaniechanie);
                                podatki[8].Add(p.ZalFIS);
                        }
                   }
               }
           }
    
           void Recalc() {
               if (opodatkowaneZUS==null) {
                   opodatkowaneZUS = new ArrayList();
                   opodatkowaneZdrow = new ArrayList();
                   opodatkowane = new ArrayList();
                   zasiłki = new ArrayList();
                   nieOpodatkowane = new ArrayList();
                   nieOpZasiłki = new ArrayList();
    
                   foreach (Total tot in ht.Values)
                       if (tot.Opodatkowany) {
                           if (tot.Zasiłek) {
                               zasiłki.Add(tot);
                               nieOpZasiłki.Add(tot);
                           }
                           else {
                               if (!srpars.OpodatWgSkł || tot.PodstZUS)
                                   opodatkowaneZUS.Add(tot);
                               else if (tot.PodstZdrow)
                                   opodatkowaneZdrow.Add(tot);
                               else
                                   opodatkowane.Add(tot);
                               nieOpodatkowane.Add(tot);
                           }
                       }
                       else if (tot.Zasiłek)
                           nieOpZasiłki.Add(tot);
                       else
                           nieOpodatkowane.Add(tot);
    
                   opodatkowaneZUS.Sort();
                   opodatkowaneZdrow.Sort();
                   opodatkowane.Sort();
                   zasiłki.Sort();
                   nieOpodatkowane.Sort();
                   nieOpZasiłki.Sort();
               }
           }
    
			public Pracownik Pracownik { 
				get { return pracownik; } 
			}
			public ListaPlac Lista {
				get { return lista; } 
			}
			public FromTo Okres {
				get { return okres; } 
			}			
			public string NumeryWypłat {
				get { return numeryWypłat; } 
			}
           public Składka[] SkłZUS {
               get { return składkiZUS; }
           }
            public List<Składka> SkłNFZ {
               get { return składkiNFZ; }
           }
           public Składka[] SkłPoz {
               get { return składkiPoz; }
           }

            public Składka[] SkłPPK {
                get { return składkiPPK; }
            }

           public List<Kwota> Podatki {
               get { return podatki; }
           }
           public Wypłata[] Wypłaty {
               get { return wypłaty; }
           }
           public LiczbaElementow[] Liczby {
				get {
					return new LiczbaElementow[] { 
						new LiczbaElementow("Wypłaty", cwyplaty), 
						new LiczbaElementow("Elementy", celementy)
					};
				}
           }
           public ICollection Opodatkowane {
               get {
                   Recalc();
                   return opodatkowane;
               }
           }
           public ICollection OpodatkowaneZUS {
               get {
                   Recalc();
                   return opodatkowaneZUS;
               }
           }
           public ICollection OpodatkowaneZdrow {
               get {
                   Recalc();
                   return opodatkowaneZdrow;
               }
           }
           public ICollection Zasiłki {
               get {
                   Recalc();
                   return zasiłki;
               }
           }
           public ICollection NieOpodatkowane {
               get {
                   Recalc();
                   return nieOpodatkowane;
               }
           }
           public ICollection NieOpZasiłki {
               get {
                   Recalc();
                   return nieOpZasiłki;
               }
           }
       }

       public class SrParams : SerializableContextBase {
           public SrParams(Context context) : base(context) {
           }
           
            //Wypłaty za akordy mają być drukowane z podziałem na definicje akordów
            //static bool akordWgDef = false;
           //Wypłaty za akordy mają być drukowane z podziałem na definicje akordów
           //static bool akordWgDef = false;
           bool akordWgDef = false;
           [Priority(1)]
           [Caption("Akordy wg definicji")]
           public bool AkordWgDef {
               get { return akordWgDef; }
               set {
                   akordWgDef = value;
                   OnChanged(EventArgs.Empty);
               }
           }

           //Elementy opodatkowane stanowiące podstawę składek na ubezpieczenia społeczne, zdrowotne i nie
           //stanowiące podstawy składek mają być wykazywane osobno (true) lub razem (false)
           //static bool opodatWgSkł = true;
           bool opodatWgSkł = true;
           [Priority(2)]
           [Caption("Opodatk. wg składki")]
           public bool OpodatWgSkł {
               get { return opodatWgSkł; }
               set {
                   opodatWgSkł = value;
                   OnChanged(EventArgs.Empty);
               }
           }
       }

       SrParams srpars;
       [SettingsContext]
       public SrParams SrPars {
           get { return srpars; }
           set { srpars = value; }
       }
		    
       string headrTitle;
		        
    void OnContextLoad(Object sender, EventArgs args) {
		if (!srpars.OpodatWgSkł)
			colOpodInfo.Caption = "Opodatkowane elementy wynagrodzenia";

        headrTitle = ReportHeader1.Title;
		bool IsPPK = false;
            
        Row[] rows = (Row[])dc.Get(typeof(Row[]));
        ListaPlac listaPłac = (ListaPlac)dc.Get(typeof(ListaPlac));
        FromTo okres = ((OkresContext)dc.Get(typeof(OkresContext))).Okres;
        Hashtable ht = new Hashtable();
        foreach (Wyplata w in rows) {
			Pracownik p = w.Pracownik;
            IsPPK |= JestPPK(p, ((Wyplata)w).Data);
			ArrayList lista = (ArrayList)ht[p];
			if (lista==null)
				ht.Add(p, lista = new ArrayList());
			lista.Add(w);
        }

        gridSklPPK.Visible = IsPPK;

        ArrayList podsumowania = new ArrayList();
        foreach (DictionaryEntry de in ht) {
            Podsumowanie pl = new Podsumowanie(listaPłac, (Pracownik)de.Key, okres, srpars, JestPolskiLad(((Wyplata)((ArrayList)de.Value)[0]).Data));
            pl.Add((IEnumerable)de.Value);
            podsumowania.Add(pl);
		}
		
		podsumowania.Sort();
        
        DataRepeater1.DataSource = podsumowania;
    }

       private bool JestPolskiLad(Date data)
        {
            return data.Year >= 2022;
        }


    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        Podsumowanie podsumowanie = (Podsumowanie)DataRepeater1.CurrentRow;

        ReportHeader1.Title = headrTitle;
        ReportHeader1["LISTA"] = podsumowanie.Lista == null ? "" : podsumowanie.Lista.Numer.Pelny;
        ReportHeader1["PRACOWNIK"] = podsumowanie.Pracownik.ToString();
        
		Update(podsumowanie.OpodatkowaneZdrow, Grid5, dlOpodatZdrow, true);
        Update(podsumowanie.Opodatkowane, Grid8, dlOpodat, true);
        Update(podsumowanie.Zasiłki, Grid2, dlZasOpodat, true);
        Update(podsumowanie.NieOpodatkowane, Grid3, dlNieopodat, false);
        Update(podsumowanie.NieOpZasiłki, Grid4, dlZasNieOp, false);
    }

            private bool JestPPK(ISessionable session, Date data) {
            YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
            return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
        }
    
    static void Update(ICollection c, Grid grid, DataLabel label, bool opodat) {
        bool any = false;
        foreach (Total t in c) {
            if (opodat)
                any = t.LiczbaOP > 0;
            else
                any = t.LiczbaNp > 0;
            if (any)
                break;
        }
		if (any) {
			grid.Visible = true;
			label.EditValue = "<p/>";
		}
		else {
			grid.Visible = false;
			label.EditValue = "";
		}
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        Total t = (Total)args.Row;
        args.VisibleRow &= t.LiczbaOP != 0;
    }

    protected void Grid5_BeforeRow(object sender, RowEventArgs args) {
        Total t = (Total)args.Row;
        args.VisibleRow &= t.LiczbaOP != 0;
    }

    protected void Grid8_BeforeRow(object sender, RowEventArgs args) {
        Total t = (Total)args.Row;
        args.VisibleRow &= t.LiczbaOP != 0;
    }

    protected void Grid2_BeforeRow(object sender, RowEventArgs args) {
        Total t = (Total)args.Row;
        args.VisibleRow &= t.LiczbaOP != 0;
    }

    protected void Grid3_BeforeRow(object sender, RowEventArgs args) {
        Total t = (Total)args.Row;
        args.VisibleRow &= t.LiczbaNp != 0;
    }

    protected void Grid4_BeforeRow(object sender, RowEventArgs args) {
        Total t = (Total)args.Row;
        args.VisibleRow &= t.LiczbaNp != 0;
    }
</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ZestawienieListPłac" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" Height="357px" Width="100%" OnBeforeRow="DataRepeater1_BeforeRow">
				<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
				<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Zestawienie wypłat&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;&lt;/strong&gt;Lista płac:&lt;strong&gt; %LISTA%&lt;BR&gt;&lt;/strong&gt;Pracownik:&lt;strong&gt; %PRACOWNIK%&lt;BR&gt;&lt;/strong&gt;Okres:&lt;strong&gt; {2}&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;"
					runat="server" DataMember2="Okres"></cc1:ReportHeader>
				<FONT face="Tahoma" size="2">Wypłaty:
					<ea:DataLabel id="DataLabel1" runat="server" DataMember="NumeryWypłat" Bold="False"></ea:DataLabel></FONT><BR>
				<ea:grid id="Grid1" runat="server" DataMember="OpodatkowaneZUS" 
                    onbeforerow="Grid1_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Opodatkowane elementy wynagrodzenia (podst. ubezp. społecznych)"
							ID="colOpodInfo"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaOP" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiOP" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaOP" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="Pagebreak12" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid5" runat="server" DataMember="OpodatkowaneZdrow" 
                    onbeforerow="Grid5_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Opodatkowane elementy wynagrodzenia (podst. ubezp. zdrowotnego)"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaOP" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiOP" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaOP" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlOpodatZdrow" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="Pagebreak11" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid8" runat="server" DataMember="Opodatkowane" 
                    onbeforerow="Grid8_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Opodatkowane elementy wynagrodzenia (pozostałe)"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaOP" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiOP" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaOP" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlOpodat" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak10" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid2" runat="server" DataMember="Zasiłki" WithSections="False" 
                    onbeforerow="Grid2_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Opodatkowane zasiłki"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaOP" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiOP" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaOP" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlZasOpodat" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak9" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid3" runat="server" DataMember="NieOpodatkowane" 
                    WithSections="False" onbeforerow="Grid3_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Nieopodatkowane elementy wynagrodzenia"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaNp" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiNp" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaNp" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlNieopodat" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak8" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid4" runat="server" DataMember="NieOpZasiłki" 
                    WithSections="False" onbeforerow="Grid4_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Nieopodatkowane zasiłki"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaNp" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiNp" Total="Sum" 
                            Caption="Dodatki" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaNp" Total="Sum" Caption="Potrącenia"
							Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlZasNieOp" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak7" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridSklSpol" runat="server" DataMember="SkłZUS" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Składki na ubezpieczenia społeczne"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Podstawa" Caption="Podstawa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Prac" Total="Sum" Caption="Ubezpieczony" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Firma" Total="Sum" Caption="Płatnik" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" Total="Sum" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak6" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridSklZdrow" runat="server" DataMember="SkłNFZ" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Składka na ubezpieczenie zdrowotne"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Podstawa" Caption="Podstawa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Prac" Caption="Ubezpieczony" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Firma" Caption="Płatnik" HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak5" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridSklPoz" runat="server" DataMember="SkłPoz" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Pozostałe składki"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Podstawa" Caption="Podstawa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Prac" Total="Sum" Caption="Ubezpieczony" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Firma" Total="Sum" Caption="Płatnik" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" Total="Sum" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
                <ea:PageBreak id="PageBreak13" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridSklPPK" runat="server" DataMember="SkłPPK" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Składki na PPK"></ea:GridColumn>
                        <ea:GridColumn Width="15" Align="Right" DataMember="Podstawa" Caption="Podstawa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Prac" Caption="Podstawowa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Firma" Caption="Dodatkowa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak4" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid6" runat="server" DataMember="Podatki" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Podatki"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Wartość" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak3" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid7" runat="server" DataMember="Wypłaty" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn Caption="Do wypłaty"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Got&#243;wka" HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Przelew" HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridLiczby" runat="server" DataMember="Liczby" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn Width="30" DataMember="Opis" Caption="Podsumowanie"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Liczba"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
				<ea:SectionMarker id="SectionMarker3" runat="server" SectionType="Footer"></ea:SectionMarker>
			</ea:datarepeater>
		</form>
	</body>
</HTML>
